clear all
close all
clc
addpath(genpath(pwd))


%PARAMETERS
N = 512;
win_func = hamming(N);
frame_advance = N/4;

%INPUT FILE
[x,fs] = wavread('sa1.wav');
x = x./max(abs(x));
sound(x,fs)

%COMPUTE SHORT-TIME SPECTRUM
[X,x_k] = stft(x,win_func,frame_advance);

%PLOT SPECTRUM
figure()
timefreqplot(abs(X(1:end/2,:)),fs)
title('Short-time Magnitude Spectrum');
drawnow;

%COMPUTE SHORT-TIME CEPSTRUM
C = stft2cep(X);

%PLOT CEPSTRUM
figure()
timequefplot(C(2:end,:),fs);%cepstrum (omitting the first cepstral coeff)
title('Short-time Cepstrum')
drawnow;

%MEL PARAMETERS
NumLinFilts = 30; 
NumLogFilts = 20;
frame_length = N;
lin_limit = 1000;

%CREATE MEL FILTERBANK
[mel_filter,fc,a] = melbank(fs,NumLinFilts,NumLogFilts,frame_length,lin_limit);

%PLOT FILTERBANK
figure()
plot(mel_filter')
title('MEL FILTERBANK')
drawnow;

%COMPUTE SHORT-TIME MEL-CEPSTRUM
MFCC = stft2melcep(X,mel_filter);

%PLOT MEL-CEPSTRUM
figure()
timequefplot(MFCC(2:end,:),fs);%melcepstrum (omitting the first cepstral coeff)
title('Short-time MEL-Cepstrum')
drawnow;

%INVERSION PARAMETERS
iterations = 500;

%INVERT THE SHORT_TIME CEPSTRUM
xe_C = invcep(C,win_func,frame_advance,iterations);
sound(xe_C,fs)

%INVERT THE SHORT_TIME MEL-CEPSTRUM
xe_MFCC = invmelcep(MFCC,win_func,frame_advance,iterations,fs,NumLinFilts,NumLogFilts);
sound(xe_MFCC,fs)







